package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.{LockToken, EntityId, EntityName}
import scala.jdk.CollectionConverters.*
final case class DeleteWebAclRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    id: EntityId,
    lockToken: LockToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DeleteWebAclRequest = {
    import DeleteWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DeleteWebAclRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .id(EntityId.unwrap(id): java.lang.String)
      .lockToken(LockToken.unwrap(lockToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.DeleteWebAclRequest.ReadOnly =
    zio.aws.wafv2.model.DeleteWebAclRequest.wrap(buildAwsValue())
}
object DeleteWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DeleteWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DeleteWebAclRequest =
      zio.aws.wafv2.model.DeleteWebAclRequest(name, scope, id, lockToken)
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def id: EntityId
    def lockToken: LockToken
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getLockToken: ZIO[Any, Nothing, LockToken] = ZIO.succeed(lockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DeleteWebAclRequest
  ) extends zio.aws.wafv2.model.DeleteWebAclRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val lockToken: LockToken =
      zio.aws.wafv2.model.primitives.LockToken(impl.lockToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DeleteWebAclRequest
  ): zio.aws.wafv2.model.DeleteWebAclRequest.ReadOnly = new Wrapper(impl)
}
