package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.VendorName
import scala.jdk.CollectionConverters.*
final case class DescribeManagedProductsByVendorRequest(
    vendorName: VendorName,
    scope: zio.aws.wafv2.model.Scope
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorRequest = {
    import DescribeManagedProductsByVendorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorRequest
      .builder()
      .vendorName(VendorName.unwrap(vendorName): java.lang.String)
      .scope(scope.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.DescribeManagedProductsByVendorRequest.ReadOnly =
    zio.aws.wafv2.model.DescribeManagedProductsByVendorRequest
      .wrap(buildAwsValue())
}
object DescribeManagedProductsByVendorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DescribeManagedProductsByVendorRequest =
      zio.aws.wafv2.model
        .DescribeManagedProductsByVendorRequest(vendorName, scope)
    def vendorName: VendorName
    def scope: zio.aws.wafv2.model.Scope
    def getVendorName: ZIO[Any, Nothing, VendorName] = ZIO.succeed(vendorName)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorRequest
  ) extends zio.aws.wafv2.model.DescribeManagedProductsByVendorRequest.ReadOnly {
    override val vendorName: VendorName =
      zio.aws.wafv2.model.primitives.VendorName(impl.vendorName())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DescribeManagedProductsByVendorRequest
  ): zio.aws.wafv2.model.DescribeManagedProductsByVendorRequest.ReadOnly =
    new Wrapper(impl)
}
