package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class DisassociateWebAclRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DisassociateWebAclRequest = {
    import DisassociateWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DisassociateWebAclRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.DisassociateWebAclRequest.ReadOnly =
    zio.aws.wafv2.model.DisassociateWebAclRequest.wrap(buildAwsValue())
}
object DisassociateWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DisassociateWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DisassociateWebAclRequest =
      zio.aws.wafv2.model.DisassociateWebAclRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DisassociateWebAclRequest
  ) extends zio.aws.wafv2.model.DisassociateWebAclRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DisassociateWebAclRequest
  ): zio.aws.wafv2.model.DisassociateWebAclRequest.ReadOnly = new Wrapper(impl)
}
