package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.FieldIdentifier
import scala.jdk.CollectionConverters.*
final case class EmailField(identifier: FieldIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.EmailField = {
    import EmailField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.EmailField
      .builder()
      .identifier(FieldIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.EmailField.ReadOnly =
    zio.aws.wafv2.model.EmailField.wrap(buildAwsValue())
}
object EmailField {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.EmailField] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.EmailField =
      zio.aws.wafv2.model.EmailField(identifier)
    def identifier: FieldIdentifier
    def getIdentifier: ZIO[Any, Nothing, FieldIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.EmailField
  ) extends zio.aws.wafv2.model.EmailField.ReadOnly {
    override val identifier: FieldIdentifier =
      zio.aws.wafv2.model.primitives.FieldIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.EmailField
  ): zio.aws.wafv2.model.EmailField.ReadOnly = new Wrapper(impl)
}
