package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class ExcludedRule(name: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ExcludedRule = {
    import ExcludedRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ExcludedRule
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ExcludedRule.ReadOnly =
    zio.aws.wafv2.model.ExcludedRule.wrap(buildAwsValue())
}
object ExcludedRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ExcludedRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ExcludedRule =
      zio.aws.wafv2.model.ExcludedRule(name)
    def name: EntityName
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ExcludedRule
  ) extends zio.aws.wafv2.model.ExcludedRule.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ExcludedRule
  ): zio.aws.wafv2.model.ExcludedRule.ReadOnly = new Wrapper(impl)
}
