package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait FallbackBehavior {
  def unwrap: software.amazon.awssdk.services.wafv2.model.FallbackBehavior
}
object FallbackBehavior {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.FallbackBehavior
  ): zio.aws.wafv2.model.FallbackBehavior = value match {
    case software.amazon.awssdk.services.wafv2.model.FallbackBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.FallbackBehavior.MATCH =>
      val r = MATCH
      r
    case software.amazon.awssdk.services.wafv2.model.FallbackBehavior.NO_MATCH =>
      val r = NO_MATCH
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.FallbackBehavior {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FallbackBehavior =
      software.amazon.awssdk.services.wafv2.model.FallbackBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object MATCH extends zio.aws.wafv2.model.FallbackBehavior {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FallbackBehavior =
      software.amazon.awssdk.services.wafv2.model.FallbackBehavior.MATCH
  }
  case object NO_MATCH extends zio.aws.wafv2.model.FallbackBehavior {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FallbackBehavior =
      software.amazon.awssdk.services.wafv2.model.FallbackBehavior.NO_MATCH
  }
}
