package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FieldToMatch(
    singleHeader: Optional[zio.aws.wafv2.model.SingleHeader] = Optional.Absent,
    singleQueryArgument: Optional[zio.aws.wafv2.model.SingleQueryArgument] =
      Optional.Absent,
    allQueryArguments: Optional[zio.aws.wafv2.model.AllQueryArguments] =
      Optional.Absent,
    uriPath: Optional[zio.aws.wafv2.model.UriPath] = Optional.Absent,
    queryString: Optional[zio.aws.wafv2.model.QueryString] = Optional.Absent,
    body: Optional[zio.aws.wafv2.model.Body] = Optional.Absent,
    method: Optional[zio.aws.wafv2.model.Method] = Optional.Absent,
    jsonBody: Optional[zio.aws.wafv2.model.JsonBody] = Optional.Absent,
    headers: Optional[zio.aws.wafv2.model.Headers] = Optional.Absent,
    cookies: Optional[zio.aws.wafv2.model.Cookies] = Optional.Absent,
    headerOrder: Optional[zio.aws.wafv2.model.HeaderOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.FieldToMatch = {
    import FieldToMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.FieldToMatch
      .builder()
      .optionallyWith(singleHeader.map(value => value.buildAwsValue()))(
        _.singleHeader
      )
      .optionallyWith(singleQueryArgument.map(value => value.buildAwsValue()))(
        _.singleQueryArgument
      )
      .optionallyWith(allQueryArguments.map(value => value.buildAwsValue()))(
        _.allQueryArguments
      )
      .optionallyWith(uriPath.map(value => value.buildAwsValue()))(_.uriPath)
      .optionallyWith(queryString.map(value => value.buildAwsValue()))(
        _.queryString
      )
      .optionallyWith(body.map(value => value.buildAwsValue()))(_.body)
      .optionallyWith(method.map(value => value.buildAwsValue()))(_.method)
      .optionallyWith(jsonBody.map(value => value.buildAwsValue()))(_.jsonBody)
      .optionallyWith(headers.map(value => value.buildAwsValue()))(_.headers)
      .optionallyWith(cookies.map(value => value.buildAwsValue()))(_.cookies)
      .optionallyWith(headerOrder.map(value => value.buildAwsValue()))(
        _.headerOrder
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.FieldToMatch.ReadOnly =
    zio.aws.wafv2.model.FieldToMatch.wrap(buildAwsValue())
}
object FieldToMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.FieldToMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.FieldToMatch =
      zio.aws.wafv2.model.FieldToMatch(
        singleHeader.map(value => value.asEditable),
        singleQueryArgument.map(value => value.asEditable),
        allQueryArguments.map(value => value.asEditable),
        uriPath.map(value => value.asEditable),
        queryString.map(value => value.asEditable),
        body.map(value => value.asEditable),
        method.map(value => value.asEditable),
        jsonBody.map(value => value.asEditable),
        headers.map(value => value.asEditable),
        cookies.map(value => value.asEditable),
        headerOrder.map(value => value.asEditable)
      )
    def singleHeader: Optional[zio.aws.wafv2.model.SingleHeader.ReadOnly]
    def singleQueryArgument
        : Optional[zio.aws.wafv2.model.SingleQueryArgument.ReadOnly]
    def allQueryArguments
        : Optional[zio.aws.wafv2.model.AllQueryArguments.ReadOnly]
    def uriPath: Optional[zio.aws.wafv2.model.UriPath.ReadOnly]
    def queryString: Optional[zio.aws.wafv2.model.QueryString.ReadOnly]
    def body: Optional[zio.aws.wafv2.model.Body.ReadOnly]
    def method: Optional[zio.aws.wafv2.model.Method.ReadOnly]
    def jsonBody: Optional[zio.aws.wafv2.model.JsonBody.ReadOnly]
    def headers: Optional[zio.aws.wafv2.model.Headers.ReadOnly]
    def cookies: Optional[zio.aws.wafv2.model.Cookies.ReadOnly]
    def headerOrder: Optional[zio.aws.wafv2.model.HeaderOrder.ReadOnly]
    def getSingleHeader
        : ZIO[Any, AwsError, zio.aws.wafv2.model.SingleHeader.ReadOnly] =
      AwsError.unwrapOptionField("singleHeader", singleHeader)
    def getSingleQueryArgument
        : ZIO[Any, AwsError, zio.aws.wafv2.model.SingleQueryArgument.ReadOnly] =
      AwsError.unwrapOptionField("singleQueryArgument", singleQueryArgument)
    def getAllQueryArguments
        : ZIO[Any, AwsError, zio.aws.wafv2.model.AllQueryArguments.ReadOnly] =
      AwsError.unwrapOptionField("allQueryArguments", allQueryArguments)
    def getUriPath: ZIO[Any, AwsError, zio.aws.wafv2.model.UriPath.ReadOnly] =
      AwsError.unwrapOptionField("uriPath", uriPath)
    def getQueryString
        : ZIO[Any, AwsError, zio.aws.wafv2.model.QueryString.ReadOnly] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getBody: ZIO[Any, AwsError, zio.aws.wafv2.model.Body.ReadOnly] =
      AwsError.unwrapOptionField("body", body)
    def getMethod: ZIO[Any, AwsError, zio.aws.wafv2.model.Method.ReadOnly] =
      AwsError.unwrapOptionField("method", method)
    def getJsonBody: ZIO[Any, AwsError, zio.aws.wafv2.model.JsonBody.ReadOnly] =
      AwsError.unwrapOptionField("jsonBody", jsonBody)
    def getHeaders: ZIO[Any, AwsError, zio.aws.wafv2.model.Headers.ReadOnly] =
      AwsError.unwrapOptionField("headers", headers)
    def getCookies: ZIO[Any, AwsError, zio.aws.wafv2.model.Cookies.ReadOnly] =
      AwsError.unwrapOptionField("cookies", cookies)
    def getHeaderOrder
        : ZIO[Any, AwsError, zio.aws.wafv2.model.HeaderOrder.ReadOnly] =
      AwsError.unwrapOptionField("headerOrder", headerOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.FieldToMatch
  ) extends zio.aws.wafv2.model.FieldToMatch.ReadOnly {
    override val singleHeader
        : Optional[zio.aws.wafv2.model.SingleHeader.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleHeader())
        .map(value => zio.aws.wafv2.model.SingleHeader.wrap(value))
    override val singleQueryArgument
        : Optional[zio.aws.wafv2.model.SingleQueryArgument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleQueryArgument())
        .map(value => zio.aws.wafv2.model.SingleQueryArgument.wrap(value))
    override val allQueryArguments
        : Optional[zio.aws.wafv2.model.AllQueryArguments.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allQueryArguments())
        .map(value => zio.aws.wafv2.model.AllQueryArguments.wrap(value))
    override val uriPath: Optional[zio.aws.wafv2.model.UriPath.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uriPath())
        .map(value => zio.aws.wafv2.model.UriPath.wrap(value))
    override val queryString
        : Optional[zio.aws.wafv2.model.QueryString.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryString())
        .map(value => zio.aws.wafv2.model.QueryString.wrap(value))
    override val body: Optional[zio.aws.wafv2.model.Body.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.body())
        .map(value => zio.aws.wafv2.model.Body.wrap(value))
    override val method: Optional[zio.aws.wafv2.model.Method.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.method())
        .map(value => zio.aws.wafv2.model.Method.wrap(value))
    override val jsonBody: Optional[zio.aws.wafv2.model.JsonBody.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jsonBody())
        .map(value => zio.aws.wafv2.model.JsonBody.wrap(value))
    override val headers: Optional[zio.aws.wafv2.model.Headers.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headers())
        .map(value => zio.aws.wafv2.model.Headers.wrap(value))
    override val cookies: Optional[zio.aws.wafv2.model.Cookies.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cookies())
        .map(value => zio.aws.wafv2.model.Cookies.wrap(value))
    override val headerOrder
        : Optional[zio.aws.wafv2.model.HeaderOrder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headerOrder())
        .map(value => zio.aws.wafv2.model.HeaderOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.FieldToMatch
  ): zio.aws.wafv2.model.FieldToMatch.ReadOnly = new Wrapper(impl)
}
