package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Filter(
    behavior: zio.aws.wafv2.model.FilterBehavior,
    requirement: zio.aws.wafv2.model.FilterRequirement,
    conditions: Iterable[zio.aws.wafv2.model.Condition]
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Filter
      .builder()
      .behavior(behavior.unwrap)
      .requirement(requirement.unwrap)
      .conditions(conditions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Filter.ReadOnly =
    zio.aws.wafv2.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Filter = zio.aws.wafv2.model.Filter(
      behavior,
      requirement,
      conditions.map { item =>
        item.asEditable
      }
    )
    def behavior: zio.aws.wafv2.model.FilterBehavior
    def requirement: zio.aws.wafv2.model.FilterRequirement
    def conditions: List[zio.aws.wafv2.model.Condition.ReadOnly]
    def getBehavior: ZIO[Any, Nothing, zio.aws.wafv2.model.FilterBehavior] =
      ZIO.succeed(behavior)
    def getRequirement
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FilterRequirement] =
      ZIO.succeed(requirement)
    def getConditions
        : ZIO[Any, Nothing, List[zio.aws.wafv2.model.Condition.ReadOnly]] =
      ZIO.succeed(conditions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Filter
  ) extends zio.aws.wafv2.model.Filter.ReadOnly {
    override val behavior: zio.aws.wafv2.model.FilterBehavior =
      zio.aws.wafv2.model.FilterBehavior.wrap(impl.behavior())
    override val requirement: zio.aws.wafv2.model.FilterRequirement =
      zio.aws.wafv2.model.FilterRequirement.wrap(impl.requirement())
    override val conditions: List[zio.aws.wafv2.model.Condition.ReadOnly] = impl
      .conditions()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.Condition.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Filter
  ): zio.aws.wafv2.model.Filter.ReadOnly = new Wrapper(impl)
}
