package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait FilterRequirement {
  def unwrap: software.amazon.awssdk.services.wafv2.model.FilterRequirement
}
object FilterRequirement {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.FilterRequirement
  ): zio.aws.wafv2.model.FilterRequirement = value match {
    case software.amazon.awssdk.services.wafv2.model.FilterRequirement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.FilterRequirement.MEETS_ALL =>
      val r = MEETS_ALL
      r
    case software.amazon.awssdk.services.wafv2.model.FilterRequirement.MEETS_ANY =>
      val r = MEETS_ANY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafv2.model.FilterRequirement {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FilterRequirement =
      software.amazon.awssdk.services.wafv2.model.FilterRequirement.UNKNOWN_TO_SDK_VERSION
  }
  case object MEETS_ALL extends zio.aws.wafv2.model.FilterRequirement {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FilterRequirement =
      software.amazon.awssdk.services.wafv2.model.FilterRequirement.MEETS_ALL
  }
  case object MEETS_ANY extends zio.aws.wafv2.model.FilterRequirement {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.FilterRequirement =
      software.amazon.awssdk.services.wafv2.model.FilterRequirement.MEETS_ANY
  }
}
