package zio.aws.wafv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.{RulePriority, EntityName}
import scala.jdk.CollectionConverters.*
final case class FirewallManagerRuleGroup(
    name: EntityName,
    priority: RulePriority,
    firewallManagerStatement: zio.aws.wafv2.model.FirewallManagerStatement,
    overrideAction: zio.aws.wafv2.model.OverrideAction,
    visibilityConfig: zio.aws.wafv2.model.VisibilityConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.FirewallManagerRuleGroup = {
    import FirewallManagerRuleGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.FirewallManagerRuleGroup
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .priority(RulePriority.unwrap(priority): Integer)
      .firewallManagerStatement(firewallManagerStatement.buildAwsValue())
      .overrideAction(overrideAction.buildAwsValue())
      .visibilityConfig(visibilityConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly =
    zio.aws.wafv2.model.FirewallManagerRuleGroup.wrap(buildAwsValue())
}
object FirewallManagerRuleGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.FirewallManagerRuleGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.FirewallManagerRuleGroup =
      zio.aws.wafv2.model.FirewallManagerRuleGroup(
        name,
        priority,
        firewallManagerStatement.asEditable,
        overrideAction.asEditable,
        visibilityConfig.asEditable
      )
    def name: EntityName
    def priority: RulePriority
    def firewallManagerStatement
        : zio.aws.wafv2.model.FirewallManagerStatement.ReadOnly
    def overrideAction: zio.aws.wafv2.model.OverrideAction.ReadOnly
    def visibilityConfig: zio.aws.wafv2.model.VisibilityConfig.ReadOnly
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getPriority: ZIO[Any, Nothing, RulePriority] = ZIO.succeed(priority)
    def getFirewallManagerStatement: ZIO[
      Any,
      Nothing,
      zio.aws.wafv2.model.FirewallManagerStatement.ReadOnly
    ] = ZIO.succeed(firewallManagerStatement)
    def getOverrideAction
        : ZIO[Any, Nothing, zio.aws.wafv2.model.OverrideAction.ReadOnly] =
      ZIO.succeed(overrideAction)
    def getVisibilityConfig
        : ZIO[Any, Nothing, zio.aws.wafv2.model.VisibilityConfig.ReadOnly] =
      ZIO.succeed(visibilityConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.FirewallManagerRuleGroup
  ) extends zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val priority: RulePriority =
      zio.aws.wafv2.model.primitives.RulePriority(impl.priority())
    override val firewallManagerStatement
        : zio.aws.wafv2.model.FirewallManagerStatement.ReadOnly =
      zio.aws.wafv2.model.FirewallManagerStatement
        .wrap(impl.firewallManagerStatement())
    override val overrideAction: zio.aws.wafv2.model.OverrideAction.ReadOnly =
      zio.aws.wafv2.model.OverrideAction.wrap(impl.overrideAction())
    override val visibilityConfig
        : zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
      zio.aws.wafv2.model.VisibilityConfig.wrap(impl.visibilityConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.FirewallManagerRuleGroup
  ): zio.aws.wafv2.model.FirewallManagerRuleGroup.ReadOnly = new Wrapper(impl)
}
