package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.APIKey
import scala.jdk.CollectionConverters.*
final case class GetDecryptedApiKeyRequest(
    scope: zio.aws.wafv2.model.Scope,
    apiKey: APIKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyRequest = {
    import GetDecryptedApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyRequest
      .builder()
      .scope(scope.unwrap)
      .apiKey(APIKey.unwrap(apiKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetDecryptedApiKeyRequest.ReadOnly =
    zio.aws.wafv2.model.GetDecryptedApiKeyRequest.wrap(buildAwsValue())
}
object GetDecryptedApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetDecryptedApiKeyRequest =
      zio.aws.wafv2.model.GetDecryptedApiKeyRequest(scope, apiKey)
    def scope: zio.aws.wafv2.model.Scope
    def apiKey: APIKey
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getApiKey: ZIO[Any, Nothing, APIKey] = ZIO.succeed(apiKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyRequest
  ) extends zio.aws.wafv2.model.GetDecryptedApiKeyRequest.ReadOnly {
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val apiKey: APIKey =
      zio.aws.wafv2.model.primitives.APIKey(impl.apiKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetDecryptedApiKeyRequest
  ): zio.aws.wafv2.model.GetDecryptedApiKeyRequest.ReadOnly = new Wrapper(impl)
}
