package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters.*
final case class GetIpSetResponse(
    ipSet: Optional[zio.aws.wafv2.model.IPSet] = Optional.Absent,
    lockToken: Optional[LockToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetIpSetResponse = {
    import GetIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetIpSetResponse
      .builder()
      .optionallyWith(ipSet.map(value => value.buildAwsValue()))(_.ipSet)
      .optionallyWith(
        lockToken.map(value => LockToken.unwrap(value): java.lang.String)
      )(_.lockToken)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetIpSetResponse.ReadOnly =
    zio.aws.wafv2.model.GetIpSetResponse.wrap(buildAwsValue())
}
object GetIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetIpSetResponse =
      zio.aws.wafv2.model.GetIpSetResponse(
        ipSet.map(value => value.asEditable),
        lockToken.map(value => value)
      )
    def ipSet: Optional[zio.aws.wafv2.model.IPSet.ReadOnly]
    def lockToken: Optional[LockToken]
    def getIpSet: ZIO[Any, AwsError, zio.aws.wafv2.model.IPSet.ReadOnly] =
      AwsError.unwrapOptionField("ipSet", ipSet)
    def getLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("lockToken", lockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetIpSetResponse
  ) extends zio.aws.wafv2.model.GetIpSetResponse.ReadOnly {
    override val ipSet: Optional[zio.aws.wafv2.model.IPSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipSet())
        .map(value => zio.aws.wafv2.model.IPSet.wrap(value))
    override val lockToken: Optional[LockToken] = zio.aws.core.internal
      .optionalFromNullable(impl.lockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetIpSetResponse
  ): zio.aws.wafv2.model.GetIpSetResponse.ReadOnly = new Wrapper(impl)
}
