package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.VersionKeyString
import scala.jdk.CollectionConverters.*
final case class GetMobileSdkReleaseRequest(
    platform: zio.aws.wafv2.model.Platform,
    releaseVersion: VersionKeyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseRequest = {
    import GetMobileSdkReleaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseRequest
      .builder()
      .platform(platform.unwrap)
      .releaseVersion(VersionKeyString.unwrap(releaseVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetMobileSdkReleaseRequest.ReadOnly =
    zio.aws.wafv2.model.GetMobileSdkReleaseRequest.wrap(buildAwsValue())
}
object GetMobileSdkReleaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetMobileSdkReleaseRequest =
      zio.aws.wafv2.model.GetMobileSdkReleaseRequest(platform, releaseVersion)
    def platform: zio.aws.wafv2.model.Platform
    def releaseVersion: VersionKeyString
    def getPlatform: ZIO[Any, Nothing, zio.aws.wafv2.model.Platform] =
      ZIO.succeed(platform)
    def getReleaseVersion: ZIO[Any, Nothing, VersionKeyString] =
      ZIO.succeed(releaseVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseRequest
  ) extends zio.aws.wafv2.model.GetMobileSdkReleaseRequest.ReadOnly {
    override val platform: zio.aws.wafv2.model.Platform =
      zio.aws.wafv2.model.Platform.wrap(impl.platform())
    override val releaseVersion: VersionKeyString =
      zio.aws.wafv2.model.primitives.VersionKeyString(impl.releaseVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetMobileSdkReleaseRequest
  ): zio.aws.wafv2.model.GetMobileSdkReleaseRequest.ReadOnly = new Wrapper(impl)
}
