package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class GetPermissionPolicyRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyRequest = {
    import GetPermissionPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetPermissionPolicyRequest.ReadOnly =
    zio.aws.wafv2.model.GetPermissionPolicyRequest.wrap(buildAwsValue())
}
object GetPermissionPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetPermissionPolicyRequest =
      zio.aws.wafv2.model.GetPermissionPolicyRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyRequest
  ) extends zio.aws.wafv2.model.GetPermissionPolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetPermissionPolicyRequest
  ): zio.aws.wafv2.model.GetPermissionPolicyRequest.ReadOnly = new Wrapper(impl)
}
