package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{EntityId, EntityName}
import scala.jdk.CollectionConverters.*
final case class GetRateBasedStatementManagedKeysRequest(
    scope: zio.aws.wafv2.model.Scope,
    webACLName: EntityName,
    webACLId: EntityId,
    ruleGroupRuleName: Optional[EntityName] = Optional.Absent,
    ruleName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysRequest = {
    import GetRateBasedStatementManagedKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysRequest
      .builder()
      .scope(scope.unwrap)
      .webACLName(EntityName.unwrap(webACLName): java.lang.String)
      .webACLId(EntityId.unwrap(webACLId): java.lang.String)
      .optionallyWith(
        ruleGroupRuleName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.ruleGroupRuleName)
      .ruleName(EntityName.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.GetRateBasedStatementManagedKeysRequest.ReadOnly =
    zio.aws.wafv2.model.GetRateBasedStatementManagedKeysRequest
      .wrap(buildAwsValue())
}
object GetRateBasedStatementManagedKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafv2.model.GetRateBasedStatementManagedKeysRequest =
      zio.aws.wafv2.model.GetRateBasedStatementManagedKeysRequest(
        scope,
        webACLName,
        webACLId,
        ruleGroupRuleName.map(value => value),
        ruleName
      )
    def scope: zio.aws.wafv2.model.Scope
    def webACLName: EntityName
    def webACLId: EntityId
    def ruleGroupRuleName: Optional[EntityName]
    def ruleName: EntityName
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getWebACLName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(webACLName)
    def getWebACLId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(webACLId)
    def getRuleGroupRuleName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("ruleGroupRuleName", ruleGroupRuleName)
    def getRuleName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysRequest
  ) extends zio.aws.wafv2.model.GetRateBasedStatementManagedKeysRequest.ReadOnly {
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val webACLName: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.webACLName())
    override val webACLId: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.webACLId())
    override val ruleGroupRuleName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupRuleName())
      .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val ruleName: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetRateBasedStatementManagedKeysRequest
  ): zio.aws.wafv2.model.GetRateBasedStatementManagedKeysRequest.ReadOnly =
    new Wrapper(impl)
}
