package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.{EntityId, EntityName}
import scala.jdk.CollectionConverters.*
final case class GetRegexPatternSetRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    id: EntityId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetRequest = {
    import GetRegexPatternSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .id(EntityId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetRegexPatternSetRequest.ReadOnly =
    zio.aws.wafv2.model.GetRegexPatternSetRequest.wrap(buildAwsValue())
}
object GetRegexPatternSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetRegexPatternSetRequest =
      zio.aws.wafv2.model.GetRegexPatternSetRequest(name, scope, id)
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def id: EntityId
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetRequest
  ) extends zio.aws.wafv2.model.GetRegexPatternSetRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetRegexPatternSetRequest
  ): zio.aws.wafv2.model.GetRegexPatternSetRequest.ReadOnly = new Wrapper(impl)
}
