package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.PopulationSize
import scala.jdk.CollectionConverters.*
final case class GetSampledRequestsResponse(
    sampledRequests: Optional[
      Iterable[zio.aws.wafv2.model.SampledHTTPRequest]
    ] = Optional.Absent,
    populationSize: Optional[PopulationSize] = Optional.Absent,
    timeWindow: Optional[zio.aws.wafv2.model.TimeWindow] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.GetSampledRequestsResponse = {
    import GetSampledRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.GetSampledRequestsResponse
      .builder()
      .optionallyWith(
        sampledRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sampledRequests)
      .optionallyWith(
        populationSize.map(value =>
          PopulationSize.unwrap(value): java.lang.Long
        )
      )(_.populationSize)
      .optionallyWith(timeWindow.map(value => value.buildAwsValue()))(
        _.timeWindow
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.GetSampledRequestsResponse.ReadOnly =
    zio.aws.wafv2.model.GetSampledRequestsResponse.wrap(buildAwsValue())
}
object GetSampledRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.GetSampledRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.GetSampledRequestsResponse =
      zio.aws.wafv2.model.GetSampledRequestsResponse(
        sampledRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        populationSize.map(value => value),
        timeWindow.map(value => value.asEditable)
      )
    def sampledRequests
        : Optional[List[zio.aws.wafv2.model.SampledHTTPRequest.ReadOnly]]
    def populationSize: Optional[PopulationSize]
    def timeWindow: Optional[zio.aws.wafv2.model.TimeWindow.ReadOnly]
    def getSampledRequests: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.SampledHTTPRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("sampledRequests", sampledRequests)
    def getPopulationSize: ZIO[Any, AwsError, PopulationSize] =
      AwsError.unwrapOptionField("populationSize", populationSize)
    def getTimeWindow
        : ZIO[Any, AwsError, zio.aws.wafv2.model.TimeWindow.ReadOnly] =
      AwsError.unwrapOptionField("timeWindow", timeWindow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.GetSampledRequestsResponse
  ) extends zio.aws.wafv2.model.GetSampledRequestsResponse.ReadOnly {
    override val sampledRequests
        : Optional[List[zio.aws.wafv2.model.SampledHTTPRequest.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampledRequests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.SampledHTTPRequest.wrap(item)
          }.toList
        )
    override val populationSize: Optional[PopulationSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.populationSize())
        .map(value => zio.aws.wafv2.model.primitives.PopulationSize(value))
    override val timeWindow: Optional[zio.aws.wafv2.model.TimeWindow.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeWindow())
        .map(value => zio.aws.wafv2.model.TimeWindow.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.GetSampledRequestsResponse
  ): zio.aws.wafv2.model.GetSampledRequestsResponse.ReadOnly = new Wrapper(impl)
}
