package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{HeaderValue, HeaderName}
import scala.jdk.CollectionConverters.*
final case class HTTPHeader(
    name: Optional[HeaderName] = Optional.Absent,
    value: Optional[HeaderValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.HTTPHeader = {
    import HTTPHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.HTTPHeader
      .builder()
      .optionallyWith(
        name.map(value => HeaderName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => HeaderValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.HTTPHeader.ReadOnly =
    zio.aws.wafv2.model.HTTPHeader.wrap(buildAwsValue())
}
object HTTPHeader {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.HTTPHeader] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.HTTPHeader = zio.aws.wafv2.model
      .HTTPHeader(name.map(value => value), value.map(value => value))
    def name: Optional[HeaderName]
    def value: Optional[HeaderValue]
    def getName: ZIO[Any, AwsError, HeaderName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, HeaderValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.HTTPHeader
  ) extends zio.aws.wafv2.model.HTTPHeader.ReadOnly {
    override val name: Optional[HeaderName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.HeaderName(value))
    override val value: Optional[HeaderValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.wafv2.model.primitives.HeaderValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.HTTPHeader
  ): zio.aws.wafv2.model.HTTPHeader.ReadOnly = new Wrapper(impl)
}
