package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Headers(
    matchPattern: zio.aws.wafv2.model.HeaderMatchPattern,
    matchScope: zio.aws.wafv2.model.MapMatchScope,
    oversizeHandling: zio.aws.wafv2.model.OversizeHandling
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Headers = {
    import Headers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Headers
      .builder()
      .matchPattern(matchPattern.buildAwsValue())
      .matchScope(matchScope.unwrap)
      .oversizeHandling(oversizeHandling.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Headers.ReadOnly =
    zio.aws.wafv2.model.Headers.wrap(buildAwsValue())
}
object Headers {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Headers] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Headers = zio.aws.wafv2.model
      .Headers(matchPattern.asEditable, matchScope, oversizeHandling)
    def matchPattern: zio.aws.wafv2.model.HeaderMatchPattern.ReadOnly
    def matchScope: zio.aws.wafv2.model.MapMatchScope
    def oversizeHandling: zio.aws.wafv2.model.OversizeHandling
    def getMatchPattern
        : ZIO[Any, Nothing, zio.aws.wafv2.model.HeaderMatchPattern.ReadOnly] =
      ZIO.succeed(matchPattern)
    def getMatchScope: ZIO[Any, Nothing, zio.aws.wafv2.model.MapMatchScope] =
      ZIO.succeed(matchScope)
    def getOversizeHandling
        : ZIO[Any, Nothing, zio.aws.wafv2.model.OversizeHandling] =
      ZIO.succeed(oversizeHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Headers
  ) extends zio.aws.wafv2.model.Headers.ReadOnly {
    override val matchPattern: zio.aws.wafv2.model.HeaderMatchPattern.ReadOnly =
      zio.aws.wafv2.model.HeaderMatchPattern.wrap(impl.matchPattern())
    override val matchScope: zio.aws.wafv2.model.MapMatchScope =
      zio.aws.wafv2.model.MapMatchScope.wrap(impl.matchScope())
    override val oversizeHandling: zio.aws.wafv2.model.OversizeHandling =
      zio.aws.wafv2.model.OversizeHandling.wrap(impl.oversizeHandling())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Headers
  ): zio.aws.wafv2.model.Headers.ReadOnly = new Wrapper(impl)
}
