package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait IPAddressVersion {
  def unwrap: software.amazon.awssdk.services.wafv2.model.IPAddressVersion
}
object IPAddressVersion {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.IPAddressVersion
  ): zio.aws.wafv2.model.IPAddressVersion = value match {
    case software.amazon.awssdk.services.wafv2.model.IPAddressVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.IPAddressVersion.IPV4 =>
      val r = IPV4
      r
    case software.amazon.awssdk.services.wafv2.model.IPAddressVersion.IPV6 =>
      val r = IPV6
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.IPAddressVersion {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.IPAddressVersion =
      software.amazon.awssdk.services.wafv2.model.IPAddressVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object IPV4 extends zio.aws.wafv2.model.IPAddressVersion {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.IPAddressVersion =
      software.amazon.awssdk.services.wafv2.model.IPAddressVersion.IPV4
  }
  case object IPV6 extends zio.aws.wafv2.model.IPAddressVersion {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.IPAddressVersion =
      software.amazon.awssdk.services.wafv2.model.IPAddressVersion.IPV6
  }
}
