package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  EntityId,
  ResourceArn,
  EntityDescription,
  EntityName,
  IPAddress
}
import scala.jdk.CollectionConverters.*
final case class IPSet(
    name: EntityName,
    id: EntityId,
    arn: ResourceArn,
    description: Optional[EntityDescription] = Optional.Absent,
    ipAddressVersion: zio.aws.wafv2.model.IPAddressVersion,
    addresses: Iterable[IPAddress]
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.IPSet = {
    import IPSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.IPSet
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .id(EntityId.unwrap(id): java.lang.String)
      .arn(ResourceArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .ipAddressVersion(ipAddressVersion.unwrap)
      .addresses(addresses.map { item =>
        IPAddress.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.IPSet.ReadOnly =
    zio.aws.wafv2.model.IPSet.wrap(buildAwsValue())
}
object IPSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.IPSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.IPSet = zio.aws.wafv2.model.IPSet(
      name,
      id,
      arn,
      description.map(value => value),
      ipAddressVersion,
      addresses
    )
    def name: EntityName
    def id: EntityId
    def arn: ResourceArn
    def description: Optional[EntityDescription]
    def ipAddressVersion: zio.aws.wafv2.model.IPAddressVersion
    def addresses: List[IPAddress]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIpAddressVersion
        : ZIO[Any, Nothing, zio.aws.wafv2.model.IPAddressVersion] =
      ZIO.succeed(ipAddressVersion)
    def getAddresses: ZIO[Any, Nothing, List[IPAddress]] =
      ZIO.succeed(addresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.IPSet
  ) extends zio.aws.wafv2.model.IPSet.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val arn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.arn())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val ipAddressVersion: zio.aws.wafv2.model.IPAddressVersion =
      zio.aws.wafv2.model.IPAddressVersion.wrap(impl.ipAddressVersion())
    override val addresses: List[IPAddress] = impl
      .addresses()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.IPAddress(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.IPSet
  ): zio.aws.wafv2.model.IPSet.ReadOnly = new Wrapper(impl)
}
