package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait JsonMatchScope {
  def unwrap: software.amazon.awssdk.services.wafv2.model.JsonMatchScope
}
object JsonMatchScope {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.JsonMatchScope
  ): zio.aws.wafv2.model.JsonMatchScope = value match {
    case software.amazon.awssdk.services.wafv2.model.JsonMatchScope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.JsonMatchScope.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.wafv2.model.JsonMatchScope.KEY =>
      val r = KEY
      r
    case software.amazon.awssdk.services.wafv2.model.JsonMatchScope.VALUE =>
      val r = VALUE
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.JsonMatchScope {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.JsonMatchScope =
      software.amazon.awssdk.services.wafv2.model.JsonMatchScope.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.wafv2.model.JsonMatchScope {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.JsonMatchScope =
      software.amazon.awssdk.services.wafv2.model.JsonMatchScope.ALL
  }
  case object KEY extends zio.aws.wafv2.model.JsonMatchScope {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.JsonMatchScope =
      software.amazon.awssdk.services.wafv2.model.JsonMatchScope.KEY
  }
  case object VALUE extends zio.aws.wafv2.model.JsonMatchScope {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.JsonMatchScope =
      software.amazon.awssdk.services.wafv2.model.JsonMatchScope.VALUE
  }
}
