package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait LabelMatchScope {
  def unwrap: software.amazon.awssdk.services.wafv2.model.LabelMatchScope
}
object LabelMatchScope {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.LabelMatchScope
  ): zio.aws.wafv2.model.LabelMatchScope = value match {
    case software.amazon.awssdk.services.wafv2.model.LabelMatchScope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.LabelMatchScope.LABEL =>
      val r = LABEL
      r
    case software.amazon.awssdk.services.wafv2.model.LabelMatchScope.NAMESPACE =>
      val r = NAMESPACE
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.LabelMatchScope {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.LabelMatchScope =
      software.amazon.awssdk.services.wafv2.model.LabelMatchScope.UNKNOWN_TO_SDK_VERSION
  }
  case object LABEL extends zio.aws.wafv2.model.LabelMatchScope {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.LabelMatchScope =
      software.amazon.awssdk.services.wafv2.model.LabelMatchScope.LABEL
  }
  case object NAMESPACE extends zio.aws.wafv2.model.LabelMatchScope {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.LabelMatchScope =
      software.amazon.awssdk.services.wafv2.model.LabelMatchScope.NAMESPACE
  }
}
