package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.LabelName
import scala.jdk.CollectionConverters.*
final case class LabelSummary(name: Optional[LabelName] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.LabelSummary = {
    import LabelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.LabelSummary
      .builder()
      .optionallyWith(
        name.map(value => LabelName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.LabelSummary.ReadOnly =
    zio.aws.wafv2.model.LabelSummary.wrap(buildAwsValue())
}
object LabelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.LabelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.LabelSummary =
      zio.aws.wafv2.model.LabelSummary(name.map(value => value))
    def name: Optional[LabelName]
    def getName: ZIO[Any, AwsError, LabelName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.LabelSummary
  ) extends zio.aws.wafv2.model.LabelSummary.ReadOnly {
    override val name: Optional[LabelName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.LabelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.LabelSummary
  ): zio.aws.wafv2.model.LabelSummary.ReadOnly = new Wrapper(impl)
}
