package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{OutputUrl, NextMarker}
import scala.jdk.CollectionConverters.*
final case class ListApiKeysResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    apiKeySummaries: Optional[Iterable[zio.aws.wafv2.model.APIKeySummary]] =
      Optional.Absent,
    applicationIntegrationURL: Optional[OutputUrl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListApiKeysResponse = {
    import ListApiKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListApiKeysResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        apiKeySummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.apiKeySummaries)
      .optionallyWith(
        applicationIntegrationURL.map(value =>
          OutputUrl.unwrap(value): java.lang.String
        )
      )(_.applicationIntegrationURL)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListApiKeysResponse.ReadOnly =
    zio.aws.wafv2.model.ListApiKeysResponse.wrap(buildAwsValue())
}
object ListApiKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListApiKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListApiKeysResponse =
      zio.aws.wafv2.model.ListApiKeysResponse(
        nextMarker.map(value => value),
        apiKeySummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationIntegrationURL.map(value => value)
      )
    def nextMarker: Optional[NextMarker]
    def apiKeySummaries
        : Optional[List[zio.aws.wafv2.model.APIKeySummary.ReadOnly]]
    def applicationIntegrationURL: Optional[OutputUrl]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getApiKeySummaries
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.APIKeySummary.ReadOnly]] =
      AwsError.unwrapOptionField("apiKeySummaries", apiKeySummaries)
    def getApplicationIntegrationURL: ZIO[Any, AwsError, OutputUrl] = AwsError
      .unwrapOptionField("applicationIntegrationURL", applicationIntegrationURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListApiKeysResponse
  ) extends zio.aws.wafv2.model.ListApiKeysResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val apiKeySummaries
        : Optional[List[zio.aws.wafv2.model.APIKeySummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKeySummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.APIKeySummary.wrap(item)
          }.toList
        )
    override val applicationIntegrationURL: Optional[OutputUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationIntegrationURL())
        .map(value => zio.aws.wafv2.model.primitives.OutputUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListApiKeysResponse
  ): zio.aws.wafv2.model.ListApiKeysResponse.ReadOnly = new Wrapper(impl)
}
