package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{VersionKeyString, NextMarker}
import scala.jdk.CollectionConverters.*
final case class ListAvailableManagedRuleGroupVersionsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    versions: Optional[Iterable[zio.aws.wafv2.model.ManagedRuleGroupVersion]] =
      Optional.Absent,
    currentDefaultVersion: Optional[VersionKeyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse = {
    import ListAvailableManagedRuleGroupVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        currentDefaultVersion.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.currentDefaultVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly =
    zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
      .wrap(buildAwsValue())
}
object ListAvailableManagedRuleGroupVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse =
      zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse(
        nextMarker.map(value => value),
        versions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        currentDefaultVersion.map(value => value)
      )
    def nextMarker: Optional[NextMarker]
    def versions
        : Optional[List[zio.aws.wafv2.model.ManagedRuleGroupVersion.ReadOnly]]
    def currentDefaultVersion: Optional[VersionKeyString]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getVersions: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.ManagedRuleGroupVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("versions", versions)
    def getCurrentDefaultVersion: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("currentDefaultVersion", currentDefaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
  ) extends zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val versions
        : Optional[List[zio.aws.wafv2.model.ManagedRuleGroupVersion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.ManagedRuleGroupVersion.wrap(item)
          }.toList
        )
    override val currentDefaultVersion: Optional[VersionKeyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentDefaultVersion())
        .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse
  ): zio.aws.wafv2.model.ListAvailableManagedRuleGroupVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
