package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{PaginationLimit, NextMarker}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAvailableManagedRuleGroupsRequest(
    scope: zio.aws.wafv2.model.Scope,
    nextMarker: Optional[NextMarker] = Optional.Absent,
    limit: Optional[PaginationLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsRequest = {
    import ListAvailableManagedRuleGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsRequest
      .builder()
      .scope(scope.unwrap)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.ListAvailableManagedRuleGroupsRequest.ReadOnly =
    zio.aws.wafv2.model.ListAvailableManagedRuleGroupsRequest
      .wrap(buildAwsValue())
}
object ListAvailableManagedRuleGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListAvailableManagedRuleGroupsRequest =
      zio.aws.wafv2.model.ListAvailableManagedRuleGroupsRequest(
        scope,
        nextMarker.map(value => value),
        limit.map(value => value)
      )
    def scope: zio.aws.wafv2.model.Scope
    def nextMarker: Optional[NextMarker]
    def limit: Optional[PaginationLimit]
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsRequest
  ) extends zio.aws.wafv2.model.ListAvailableManagedRuleGroupsRequest.ReadOnly {
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val limit: Optional[PaginationLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.wafv2.model.primitives.PaginationLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListAvailableManagedRuleGroupsRequest
  ): zio.aws.wafv2.model.ListAvailableManagedRuleGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
