package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters.*
final case class ListManagedRuleSetsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    managedRuleSets: Optional[
      Iterable[zio.aws.wafv2.model.ManagedRuleSetSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse = {
    import ListManagedRuleSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        managedRuleSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedRuleSets)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly =
    zio.aws.wafv2.model.ListManagedRuleSetsResponse.wrap(buildAwsValue())
}
object ListManagedRuleSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListManagedRuleSetsResponse =
      zio.aws.wafv2.model.ListManagedRuleSetsResponse(
        nextMarker.map(value => value),
        managedRuleSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def managedRuleSets
        : Optional[List[zio.aws.wafv2.model.ManagedRuleSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getManagedRuleSets: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.ManagedRuleSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("managedRuleSets", managedRuleSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse
  ) extends zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val managedRuleSets
        : Optional[List[zio.aws.wafv2.model.ManagedRuleSetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedRuleSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.ManagedRuleSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListManagedRuleSetsResponse
  ): zio.aws.wafv2.model.ListManagedRuleSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
