package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters.*
final case class ListMobileSdkReleasesResponse(
    releaseSummaries: Optional[Iterable[zio.aws.wafv2.model.ReleaseSummary]] =
      Optional.Absent,
    nextMarker: Optional[NextMarker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesResponse = {
    import ListMobileSdkReleasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesResponse
      .builder()
      .optionallyWith(
        releaseSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.releaseSummaries)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListMobileSdkReleasesResponse.ReadOnly =
    zio.aws.wafv2.model.ListMobileSdkReleasesResponse.wrap(buildAwsValue())
}
object ListMobileSdkReleasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListMobileSdkReleasesResponse =
      zio.aws.wafv2.model.ListMobileSdkReleasesResponse(
        releaseSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def releaseSummaries
        : Optional[List[zio.aws.wafv2.model.ReleaseSummary.ReadOnly]]
    def nextMarker: Optional[NextMarker]
    def getReleaseSummaries: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.ReleaseSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("releaseSummaries", releaseSummaries)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesResponse
  ) extends zio.aws.wafv2.model.ListMobileSdkReleasesResponse.ReadOnly {
    override val releaseSummaries
        : Optional[List[zio.aws.wafv2.model.ReleaseSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.releaseSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.ReleaseSummary.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListMobileSdkReleasesResponse
  ): zio.aws.wafv2.model.ListMobileSdkReleasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
