package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{ResourceArn, PaginationLimit, NextMarker}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    limit: Optional[PaginationLimit] = Optional.Absent,
    resourceARN: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .resourceARN(ResourceArn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.wafv2.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListTagsForResourceRequest =
      zio.aws.wafv2.model.ListTagsForResourceRequest(
        nextMarker.map(value => value),
        limit.map(value => value),
        resourceARN
      )
    def nextMarker: Optional[NextMarker]
    def limit: Optional[PaginationLimit]
    def resourceARN: ResourceArn
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getResourceARN: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest
  ) extends zio.aws.wafv2.model.ListTagsForResourceRequest.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val limit: Optional[PaginationLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.wafv2.model.primitives.PaginationLimit(value))
    override val resourceARN: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListTagsForResourceRequest
  ): zio.aws.wafv2.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
