package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.NextMarker
import scala.jdk.CollectionConverters.*
final case class ListWebAcLsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    webACLs: Optional[Iterable[zio.aws.wafv2.model.WebACLSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse = {
    import ListWebAcLsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        webACLs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.webACLs)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly =
    zio.aws.wafv2.model.ListWebAcLsResponse.wrap(buildAwsValue())
}
object ListWebAcLsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ListWebAcLsResponse =
      zio.aws.wafv2.model.ListWebAcLsResponse(
        nextMarker.map(value => value),
        webACLs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def webACLs: Optional[List[zio.aws.wafv2.model.WebACLSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getWebACLs
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.WebACLSummary.ReadOnly]] =
      AwsError.unwrapOptionField("webACLs", webACLs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse
  ) extends zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafv2.model.primitives.NextMarker(value))
    override val webACLs
        : Optional[List[zio.aws.wafv2.model.WebACLSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webACLs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.WebACLSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ListWebAcLsResponse
  ): zio.aws.wafv2.model.ListWebAcLsResponse.ReadOnly = new Wrapper(impl)
}
