package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LoggingFilter(
    filters: Iterable[zio.aws.wafv2.model.Filter],
    defaultBehavior: zio.aws.wafv2.model.FilterBehavior
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.LoggingFilter = {
    import LoggingFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.LoggingFilter
      .builder()
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .defaultBehavior(defaultBehavior.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.LoggingFilter.ReadOnly =
    zio.aws.wafv2.model.LoggingFilter.wrap(buildAwsValue())
}
object LoggingFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.LoggingFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.LoggingFilter =
      zio.aws.wafv2.model.LoggingFilter(
        filters.map { item =>
          item.asEditable
        },
        defaultBehavior
      )
    def filters: List[zio.aws.wafv2.model.Filter.ReadOnly]
    def defaultBehavior: zio.aws.wafv2.model.FilterBehavior
    def getFilters
        : ZIO[Any, Nothing, List[zio.aws.wafv2.model.Filter.ReadOnly]] =
      ZIO.succeed(filters)
    def getDefaultBehavior
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FilterBehavior] =
      ZIO.succeed(defaultBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.LoggingFilter
  ) extends zio.aws.wafv2.model.LoggingFilter.ReadOnly {
    override val filters: List[zio.aws.wafv2.model.Filter.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.Filter.wrap(item)
      }
      .toList
    override val defaultBehavior: zio.aws.wafv2.model.FilterBehavior =
      zio.aws.wafv2.model.FilterBehavior.wrap(impl.defaultBehavior())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.LoggingFilter
  ): zio.aws.wafv2.model.LoggingFilter.ReadOnly = new Wrapper(impl)
}
