package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  ProductTitle,
  ProductDescription,
  ProductLink,
  VendorName,
  ResourceArn,
  ProductId,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class ManagedProductDescriptor(
    vendorName: Optional[VendorName] = Optional.Absent,
    managedRuleSetName: Optional[EntityName] = Optional.Absent,
    productId: Optional[ProductId] = Optional.Absent,
    productLink: Optional[ProductLink] = Optional.Absent,
    productTitle: Optional[ProductTitle] = Optional.Absent,
    productDescription: Optional[ProductDescription] = Optional.Absent,
    snsTopicArn: Optional[ResourceArn] = Optional.Absent,
    isVersioningSupported: Optional[Boolean] = Optional.Absent,
    isAdvancedManagedRuleSet: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptor = {
    import ManagedProductDescriptor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptor
      .builder()
      .optionallyWith(
        vendorName.map(value => VendorName.unwrap(value): java.lang.String)
      )(_.vendorName)
      .optionallyWith(
        managedRuleSetName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.managedRuleSetName)
      .optionallyWith(
        productId.map(value => ProductId.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        productLink.map(value => ProductLink.unwrap(value): java.lang.String)
      )(_.productLink)
      .optionallyWith(
        productTitle.map(value => ProductTitle.unwrap(value): java.lang.String)
      )(_.productTitle)
      .optionallyWith(
        productDescription.map(value =>
          ProductDescription.unwrap(value): java.lang.String
        )
      )(_.productDescription)
      .optionallyWith(
        snsTopicArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        isVersioningSupported.map(value => value: java.lang.Boolean)
      )(_.isVersioningSupported)
      .optionallyWith(
        isAdvancedManagedRuleSet.map(value => value: java.lang.Boolean)
      )(_.isAdvancedManagedRuleSet)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedProductDescriptor.ReadOnly =
    zio.aws.wafv2.model.ManagedProductDescriptor.wrap(buildAwsValue())
}
object ManagedProductDescriptor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedProductDescriptor =
      zio.aws.wafv2.model.ManagedProductDescriptor(
        vendorName.map(value => value),
        managedRuleSetName.map(value => value),
        productId.map(value => value),
        productLink.map(value => value),
        productTitle.map(value => value),
        productDescription.map(value => value),
        snsTopicArn.map(value => value),
        isVersioningSupported.map(value => value),
        isAdvancedManagedRuleSet.map(value => value)
      )
    def vendorName: Optional[VendorName]
    def managedRuleSetName: Optional[EntityName]
    def productId: Optional[ProductId]
    def productLink: Optional[ProductLink]
    def productTitle: Optional[ProductTitle]
    def productDescription: Optional[ProductDescription]
    def snsTopicArn: Optional[ResourceArn]
    def isVersioningSupported: Optional[Boolean]
    def isAdvancedManagedRuleSet: Optional[Boolean]
    def getVendorName: ZIO[Any, AwsError, VendorName] =
      AwsError.unwrapOptionField("vendorName", vendorName)
    def getManagedRuleSetName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("managedRuleSetName", managedRuleSetName)
    def getProductId: ZIO[Any, AwsError, ProductId] =
      AwsError.unwrapOptionField("productId", productId)
    def getProductLink: ZIO[Any, AwsError, ProductLink] =
      AwsError.unwrapOptionField("productLink", productLink)
    def getProductTitle: ZIO[Any, AwsError, ProductTitle] =
      AwsError.unwrapOptionField("productTitle", productTitle)
    def getProductDescription: ZIO[Any, AwsError, ProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getSnsTopicArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getIsVersioningSupported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isVersioningSupported", isVersioningSupported)
    def getIsAdvancedManagedRuleSet: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("isAdvancedManagedRuleSet", isAdvancedManagedRuleSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptor
  ) extends zio.aws.wafv2.model.ManagedProductDescriptor.ReadOnly {
    override val vendorName: Optional[VendorName] = zio.aws.core.internal
      .optionalFromNullable(impl.vendorName())
      .map(value => zio.aws.wafv2.model.primitives.VendorName(value))
    override val managedRuleSetName: Optional[EntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedRuleSetName())
        .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val productId: Optional[ProductId] = zio.aws.core.internal
      .optionalFromNullable(impl.productId())
      .map(value => zio.aws.wafv2.model.primitives.ProductId(value))
    override val productLink: Optional[ProductLink] = zio.aws.core.internal
      .optionalFromNullable(impl.productLink())
      .map(value => zio.aws.wafv2.model.primitives.ProductLink(value))
    override val productTitle: Optional[ProductTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.productTitle())
      .map(value => zio.aws.wafv2.model.primitives.ProductTitle(value))
    override val productDescription: Optional[ProductDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productDescription())
        .map(value => zio.aws.wafv2.model.primitives.ProductDescription(value))
    override val snsTopicArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
    override val isVersioningSupported: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isVersioningSupported())
        .map(value => value: Boolean)
    override val isAdvancedManagedRuleSet: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isAdvancedManagedRuleSet())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptor
  ): zio.aws.wafv2.model.ManagedProductDescriptor.ReadOnly = new Wrapper(impl)
}
