package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{VersionKeyString, EntityName, VendorName}
import scala.jdk.CollectionConverters.*
final case class ManagedRuleGroupStatement(
    vendorName: VendorName,
    name: EntityName,
    version: Optional[VersionKeyString] = Optional.Absent,
    excludedRules: Optional[Iterable[zio.aws.wafv2.model.ExcludedRule]] =
      Optional.Absent,
    scopeDownStatement: Optional[zio.aws.wafv2.model.Statement] =
      Optional.Absent,
    managedRuleGroupConfigs: Optional[
      Iterable[zio.aws.wafv2.model.ManagedRuleGroupConfig]
    ] = Optional.Absent,
    ruleActionOverrides: Optional[
      Iterable[zio.aws.wafv2.model.RuleActionOverride]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupStatement = {
    import ManagedRuleGroupStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupStatement
      .builder()
      .vendorName(VendorName.unwrap(vendorName): java.lang.String)
      .name(EntityName.unwrap(name): java.lang.String)
      .optionallyWith(
        version.map(value => VersionKeyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        excludedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludedRules)
      .optionallyWith(scopeDownStatement.map(value => value.buildAwsValue()))(
        _.scopeDownStatement
      )
      .optionallyWith(
        managedRuleGroupConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedRuleGroupConfigs)
      .optionallyWith(
        ruleActionOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleActionOverrides)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly =
    zio.aws.wafv2.model.ManagedRuleGroupStatement.wrap(buildAwsValue())
}
object ManagedRuleGroupStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedRuleGroupStatement =
      zio.aws.wafv2.model.ManagedRuleGroupStatement(
        vendorName,
        name,
        version.map(value => value),
        excludedRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scopeDownStatement.map(value => value.asEditable),
        managedRuleGroupConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ruleActionOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vendorName: VendorName
    def name: EntityName
    def version: Optional[VersionKeyString]
    def excludedRules: Optional[List[zio.aws.wafv2.model.ExcludedRule.ReadOnly]]
    def scopeDownStatement: Optional[zio.aws.wafv2.model.Statement.ReadOnly]
    def managedRuleGroupConfigs
        : Optional[List[zio.aws.wafv2.model.ManagedRuleGroupConfig.ReadOnly]]
    def ruleActionOverrides
        : Optional[List[zio.aws.wafv2.model.RuleActionOverride.ReadOnly]]
    def getVendorName: ZIO[Any, Nothing, VendorName] = ZIO.succeed(vendorName)
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getVersion: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("version", version)
    def getExcludedRules
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.ExcludedRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludedRules", excludedRules)
    def getScopeDownStatement
        : ZIO[Any, AwsError, zio.aws.wafv2.model.Statement.ReadOnly] =
      AwsError.unwrapOptionField("scopeDownStatement", scopeDownStatement)
    def getManagedRuleGroupConfigs: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.ManagedRuleGroupConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "managedRuleGroupConfigs",
      managedRuleGroupConfigs
    )
    def getRuleActionOverrides: ZIO[Any, AwsError, List[
      zio.aws.wafv2.model.RuleActionOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleActionOverrides", ruleActionOverrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupStatement
  ) extends zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly {
    override val vendorName: VendorName =
      zio.aws.wafv2.model.primitives.VendorName(impl.vendorName())
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val version: Optional[VersionKeyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val excludedRules
        : Optional[List[zio.aws.wafv2.model.ExcludedRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludedRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.ExcludedRule.wrap(item)
          }.toList
        )
    override val scopeDownStatement
        : Optional[zio.aws.wafv2.model.Statement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scopeDownStatement())
        .map(value => zio.aws.wafv2.model.Statement.wrap(value))
    override val managedRuleGroupConfigs
        : Optional[List[zio.aws.wafv2.model.ManagedRuleGroupConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedRuleGroupConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.ManagedRuleGroupConfig.wrap(item)
          }.toList
        )
    override val ruleActionOverrides
        : Optional[List[zio.aws.wafv2.model.RuleActionOverride.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleActionOverrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.RuleActionOverride.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleGroupStatement
  ): zio.aws.wafv2.model.ManagedRuleGroupStatement.ReadOnly = new Wrapper(impl)
}
