package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  VersionKeyString,
  LabelName,
  EntityId,
  ResourceArn,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class ManagedRuleSet(
    name: EntityName,
    id: EntityId,
    arn: ResourceArn,
    description: Optional[EntityDescription] = Optional.Absent,
    publishedVersions: Optional[
      Map[VersionKeyString, zio.aws.wafv2.model.ManagedRuleSetVersion]
    ] = Optional.Absent,
    recommendedVersion: Optional[VersionKeyString] = Optional.Absent,
    labelNamespace: Optional[LabelName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedRuleSet = {
    import ManagedRuleSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedRuleSet
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .id(EntityId.unwrap(id): java.lang.String)
      .arn(ResourceArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        publishedVersions.map(value =>
          value
            .map({ case (key, value) =>
              (VersionKeyString.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.publishedVersions)
      .optionallyWith(
        recommendedVersion.map(value =>
          VersionKeyString.unwrap(value): java.lang.String
        )
      )(_.recommendedVersion)
      .optionallyWith(
        labelNamespace.map(value => LabelName.unwrap(value): java.lang.String)
      )(_.labelNamespace)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedRuleSet.ReadOnly =
    zio.aws.wafv2.model.ManagedRuleSet.wrap(buildAwsValue())
}
object ManagedRuleSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedRuleSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedRuleSet =
      zio.aws.wafv2.model.ManagedRuleSet(
        name,
        id,
        arn,
        description.map(value => value),
        publishedVersions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        recommendedVersion.map(value => value),
        labelNamespace.map(value => value)
      )
    def name: EntityName
    def id: EntityId
    def arn: ResourceArn
    def description: Optional[EntityDescription]
    def publishedVersions: Optional[
      Map[VersionKeyString, zio.aws.wafv2.model.ManagedRuleSetVersion.ReadOnly]
    ]
    def recommendedVersion: Optional[VersionKeyString]
    def labelNamespace: Optional[LabelName]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPublishedVersions: ZIO[Any, AwsError, Map[
      VersionKeyString,
      zio.aws.wafv2.model.ManagedRuleSetVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("publishedVersions", publishedVersions)
    def getRecommendedVersion: ZIO[Any, AwsError, VersionKeyString] =
      AwsError.unwrapOptionField("recommendedVersion", recommendedVersion)
    def getLabelNamespace: ZIO[Any, AwsError, LabelName] =
      AwsError.unwrapOptionField("labelNamespace", labelNamespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleSet
  ) extends zio.aws.wafv2.model.ManagedRuleSet.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val id: EntityId =
      zio.aws.wafv2.model.primitives.EntityId(impl.id())
    override val arn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.arn())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val publishedVersions: Optional[
      Map[VersionKeyString, zio.aws.wafv2.model.ManagedRuleSetVersion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.publishedVersions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.primitives.VersionKeyString(
              key
            ) -> zio.aws.wafv2.model.ManagedRuleSetVersion.wrap(value)
          })
          .toMap
      )
    override val recommendedVersion: Optional[VersionKeyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendedVersion())
        .map(value => zio.aws.wafv2.model.primitives.VersionKeyString(value))
    override val labelNamespace: Optional[LabelName] = zio.aws.core.internal
      .optionalFromNullable(impl.labelNamespace())
      .map(value => zio.aws.wafv2.model.primitives.LabelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleSet
  ): zio.aws.wafv2.model.ManagedRuleSet.ReadOnly = new Wrapper(impl)
}
