package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{
  Timestamp,
  TimeWindowDay,
  CapacityUnit,
  ResourceArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ManagedRuleSetVersion(
    associatedRuleGroupArn: Optional[ResourceArn] = Optional.Absent,
    capacity: Optional[CapacityUnit] = Optional.Absent,
    forecastedLifetime: Optional[TimeWindowDay] = Optional.Absent,
    publishTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdateTimestamp: Optional[Timestamp] = Optional.Absent,
    expiryTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ManagedRuleSetVersion = {
    import ManagedRuleSetVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ManagedRuleSetVersion
      .builder()
      .optionallyWith(
        associatedRuleGroupArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.associatedRuleGroupArn)
      .optionallyWith(
        capacity.map(value => CapacityUnit.unwrap(value): java.lang.Long)
      )(_.capacity)
      .optionallyWith(
        forecastedLifetime.map(value => TimeWindowDay.unwrap(value): Integer)
      )(_.forecastedLifetime)
      .optionallyWith(
        publishTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.publishTimestamp)
      .optionallyWith(
        lastUpdateTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTimestamp)
      .optionallyWith(
        expiryTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.expiryTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ManagedRuleSetVersion.ReadOnly =
    zio.aws.wafv2.model.ManagedRuleSetVersion.wrap(buildAwsValue())
}
object ManagedRuleSetVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ManagedRuleSetVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ManagedRuleSetVersion =
      zio.aws.wafv2.model.ManagedRuleSetVersion(
        associatedRuleGroupArn.map(value => value),
        capacity.map(value => value),
        forecastedLifetime.map(value => value),
        publishTimestamp.map(value => value),
        lastUpdateTimestamp.map(value => value),
        expiryTimestamp.map(value => value)
      )
    def associatedRuleGroupArn: Optional[ResourceArn]
    def capacity: Optional[CapacityUnit]
    def forecastedLifetime: Optional[TimeWindowDay]
    def publishTimestamp: Optional[Timestamp]
    def lastUpdateTimestamp: Optional[Timestamp]
    def expiryTimestamp: Optional[Timestamp]
    def getAssociatedRuleGroupArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("associatedRuleGroupArn", associatedRuleGroupArn)
    def getCapacity: ZIO[Any, AwsError, CapacityUnit] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getForecastedLifetime: ZIO[Any, AwsError, TimeWindowDay] =
      AwsError.unwrapOptionField("forecastedLifetime", forecastedLifetime)
    def getPublishTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("publishTimestamp", publishTimestamp)
    def getLastUpdateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTimestamp", lastUpdateTimestamp)
    def getExpiryTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiryTimestamp", expiryTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleSetVersion
  ) extends zio.aws.wafv2.model.ManagedRuleSetVersion.ReadOnly {
    override val associatedRuleGroupArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedRuleGroupArn())
        .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
    override val capacity: Optional[CapacityUnit] = zio.aws.core.internal
      .optionalFromNullable(impl.capacity())
      .map(value => zio.aws.wafv2.model.primitives.CapacityUnit(value))
    override val forecastedLifetime: Optional[TimeWindowDay] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastedLifetime())
        .map(value => zio.aws.wafv2.model.primitives.TimeWindowDay(value))
    override val publishTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.publishTimestamp())
      .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
    override val lastUpdateTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateTimestamp())
        .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
    override val expiryTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiryTimestamp())
      .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ManagedRuleSetVersion
  ): zio.aws.wafv2.model.ManagedRuleSetVersion.ReadOnly = new Wrapper(impl)
}
