package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class NotStatement(statement: zio.aws.wafv2.model.Statement) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.NotStatement = {
    import NotStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.NotStatement
      .builder()
      .statement(statement.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.NotStatement.ReadOnly =
    zio.aws.wafv2.model.NotStatement.wrap(buildAwsValue())
}
object NotStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.NotStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.NotStatement =
      zio.aws.wafv2.model.NotStatement(statement.asEditable)
    def statement: zio.aws.wafv2.model.Statement.ReadOnly
    def getStatement
        : ZIO[Any, Nothing, zio.aws.wafv2.model.Statement.ReadOnly] =
      ZIO.succeed(statement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.NotStatement
  ) extends zio.aws.wafv2.model.NotStatement.ReadOnly {
    override val statement: zio.aws.wafv2.model.Statement.ReadOnly =
      zio.aws.wafv2.model.Statement.wrap(impl.statement())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.NotStatement
  ): zio.aws.wafv2.model.NotStatement.ReadOnly = new Wrapper(impl)
}
