package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OrStatement(
    statements: Iterable[zio.aws.wafv2.model.Statement]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.OrStatement = {
    import OrStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.OrStatement
      .builder()
      .statements(statements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.OrStatement.ReadOnly =
    zio.aws.wafv2.model.OrStatement.wrap(buildAwsValue())
}
object OrStatement {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.OrStatement] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.OrStatement =
      zio.aws.wafv2.model.OrStatement(statements.map { item =>
        item.asEditable
      })
    def statements: List[zio.aws.wafv2.model.Statement.ReadOnly]
    def getStatements
        : ZIO[Any, Nothing, List[zio.aws.wafv2.model.Statement.ReadOnly]] =
      ZIO.succeed(statements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.OrStatement
  ) extends zio.aws.wafv2.model.OrStatement.ReadOnly {
    override val statements: List[zio.aws.wafv2.model.Statement.ReadOnly] = impl
      .statements()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.Statement.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.OrStatement
  ): zio.aws.wafv2.model.OrStatement.ReadOnly = new Wrapper(impl)
}
