package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.FieldIdentifier
import scala.jdk.CollectionConverters.*
final case class PasswordField(identifier: FieldIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.PasswordField = {
    import PasswordField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.PasswordField
      .builder()
      .identifier(FieldIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.PasswordField.ReadOnly =
    zio.aws.wafv2.model.PasswordField.wrap(buildAwsValue())
}
object PasswordField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.PasswordField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.PasswordField =
      zio.aws.wafv2.model.PasswordField(identifier)
    def identifier: FieldIdentifier
    def getIdentifier: ZIO[Any, Nothing, FieldIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.PasswordField
  ) extends zio.aws.wafv2.model.PasswordField.ReadOnly {
    override val identifier: FieldIdentifier =
      zio.aws.wafv2.model.primitives.FieldIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.PasswordField
  ): zio.aws.wafv2.model.PasswordField.ReadOnly = new Wrapper(impl)
}
