package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.FieldIdentifier
import scala.jdk.CollectionConverters.*
final case class PhoneNumberField(identifier: FieldIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.PhoneNumberField = {
    import PhoneNumberField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.PhoneNumberField
      .builder()
      .identifier(FieldIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.PhoneNumberField.ReadOnly =
    zio.aws.wafv2.model.PhoneNumberField.wrap(buildAwsValue())
}
object PhoneNumberField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.PhoneNumberField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.PhoneNumberField =
      zio.aws.wafv2.model.PhoneNumberField(identifier)
    def identifier: FieldIdentifier
    def getIdentifier: ZIO[Any, Nothing, FieldIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.PhoneNumberField
  ) extends zio.aws.wafv2.model.PhoneNumberField.ReadOnly {
    override val identifier: FieldIdentifier =
      zio.aws.wafv2.model.primitives.FieldIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.PhoneNumberField
  ): zio.aws.wafv2.model.PhoneNumberField.ReadOnly = new Wrapper(impl)
}
