package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.LabelNamespace
import scala.jdk.CollectionConverters.*
final case class RateLimitLabelNamespace(namespace: LabelNamespace) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RateLimitLabelNamespace = {
    import RateLimitLabelNamespace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RateLimitLabelNamespace
      .builder()
      .namespace(LabelNamespace.unwrap(namespace): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RateLimitLabelNamespace.ReadOnly =
    zio.aws.wafv2.model.RateLimitLabelNamespace.wrap(buildAwsValue())
}
object RateLimitLabelNamespace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RateLimitLabelNamespace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RateLimitLabelNamespace =
      zio.aws.wafv2.model.RateLimitLabelNamespace(namespace)
    def namespace: LabelNamespace
    def getNamespace: ZIO[Any, Nothing, LabelNamespace] = ZIO.succeed(namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RateLimitLabelNamespace
  ) extends zio.aws.wafv2.model.RateLimitLabelNamespace.ReadOnly {
    override val namespace: LabelNamespace =
      zio.aws.wafv2.model.primitives.LabelNamespace(impl.namespace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RateLimitLabelNamespace
  ): zio.aws.wafv2.model.RateLimitLabelNamespace.ReadOnly = new Wrapper(impl)
}
