package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.RegexPatternString
import scala.jdk.CollectionConverters.*
final case class RegexMatchStatement(
    regexString: RegexPatternString,
    fieldToMatch: zio.aws.wafv2.model.FieldToMatch,
    textTransformations: Iterable[zio.aws.wafv2.model.TextTransformation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RegexMatchStatement = {
    import RegexMatchStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RegexMatchStatement
      .builder()
      .regexString(RegexPatternString.unwrap(regexString): java.lang.String)
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformations(textTransformations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RegexMatchStatement.ReadOnly =
    zio.aws.wafv2.model.RegexMatchStatement.wrap(buildAwsValue())
}
object RegexMatchStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RegexMatchStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RegexMatchStatement =
      zio.aws.wafv2.model.RegexMatchStatement(
        regexString,
        fieldToMatch.asEditable,
        textTransformations.map { item =>
          item.asEditable
        }
      )
    def regexString: RegexPatternString
    def fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly
    def textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly]
    def getRegexString: ZIO[Any, Nothing, RegexPatternString] =
      ZIO.succeed(regexString)
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformations: ZIO[Any, Nothing, List[
      zio.aws.wafv2.model.TextTransformation.ReadOnly
    ]] = ZIO.succeed(textTransformations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RegexMatchStatement
  ) extends zio.aws.wafv2.model.RegexMatchStatement.ReadOnly {
    override val regexString: RegexPatternString =
      zio.aws.wafv2.model.primitives.RegexPatternString(impl.regexString())
    override val fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly =
      zio.aws.wafv2.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly] = impl
      .textTransformations()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.TextTransformation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RegexMatchStatement
  ): zio.aws.wafv2.model.RegexMatchStatement.ReadOnly = new Wrapper(impl)
}
