package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  EntityDescription,
  ResourceArn,
  EntityId,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class RegexPatternSet(
    name: Optional[EntityName] = Optional.Absent,
    id: Optional[EntityId] = Optional.Absent,
    arn: Optional[ResourceArn] = Optional.Absent,
    description: Optional[EntityDescription] = Optional.Absent,
    regularExpressionList: Optional[Iterable[zio.aws.wafv2.model.Regex]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RegexPatternSet = {
    import RegexPatternSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RegexPatternSet
      .builder()
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        regularExpressionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regularExpressionList)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RegexPatternSet.ReadOnly =
    zio.aws.wafv2.model.RegexPatternSet.wrap(buildAwsValue())
}
object RegexPatternSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RegexPatternSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RegexPatternSet =
      zio.aws.wafv2.model.RegexPatternSet(
        name.map(value => value),
        id.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        regularExpressionList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[EntityName]
    def id: Optional[EntityId]
    def arn: Optional[ResourceArn]
    def description: Optional[EntityDescription]
    def regularExpressionList
        : Optional[List[zio.aws.wafv2.model.Regex.ReadOnly]]
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRegularExpressionList
        : ZIO[Any, AwsError, List[zio.aws.wafv2.model.Regex.ReadOnly]] =
      AwsError.unwrapOptionField("regularExpressionList", regularExpressionList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RegexPatternSet
  ) extends zio.aws.wafv2.model.RegexPatternSet.ReadOnly {
    override val name: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val id: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.wafv2.model.primitives.EntityId(value))
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.wafv2.model.primitives.ResourceArn(value))
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val regularExpressionList
        : Optional[List[zio.aws.wafv2.model.Regex.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regularExpressionList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Regex.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RegexPatternSet
  ): zio.aws.wafv2.model.RegexPatternSet.ReadOnly = new Wrapper(impl)
}
