package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class RegexPatternSetReferenceStatement(
    arn: ResourceArn,
    fieldToMatch: zio.aws.wafv2.model.FieldToMatch,
    textTransformations: Iterable[zio.aws.wafv2.model.TextTransformation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RegexPatternSetReferenceStatement = {
    import RegexPatternSetReferenceStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RegexPatternSetReferenceStatement
      .builder()
      .arn(ResourceArn.unwrap(arn): java.lang.String)
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformations(textTransformations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.RegexPatternSetReferenceStatement.ReadOnly =
    zio.aws.wafv2.model.RegexPatternSetReferenceStatement.wrap(buildAwsValue())
}
object RegexPatternSetReferenceStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.RegexPatternSetReferenceStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RegexPatternSetReferenceStatement =
      zio.aws.wafv2.model.RegexPatternSetReferenceStatement(
        arn,
        fieldToMatch.asEditable,
        textTransformations.map { item =>
          item.asEditable
        }
      )
    def arn: ResourceArn
    def fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly
    def textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly]
    def getArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(arn)
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.wafv2.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformations: ZIO[Any, Nothing, List[
      zio.aws.wafv2.model.TextTransformation.ReadOnly
    ]] = ZIO.succeed(textTransformations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RegexPatternSetReferenceStatement
  ) extends zio.aws.wafv2.model.RegexPatternSetReferenceStatement.ReadOnly {
    override val arn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.arn())
    override val fieldToMatch: zio.aws.wafv2.model.FieldToMatch.ReadOnly =
      zio.aws.wafv2.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformations
        : List[zio.aws.wafv2.model.TextTransformation.ReadOnly] = impl
      .textTransformations()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.TextTransformation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RegexPatternSetReferenceStatement
  ): zio.aws.wafv2.model.RegexPatternSetReferenceStatement.ReadOnly =
    new Wrapper(impl)
}
