package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.wafv2.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.ResourceType
  ): zio.aws.wafv2.model.ResourceType = value match {
    case software.amazon.awssdk.services.wafv2.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.ResourceType.APPLICATION_LOAD_BALANCER =>
      val r = APPLICATION_LOAD_BALANCER
      r
    case software.amazon.awssdk.services.wafv2.model.ResourceType.API_GATEWAY =>
      val r = API_GATEWAY
      r
    case software.amazon.awssdk.services.wafv2.model.ResourceType.APPSYNC =>
      val r = APPSYNC
      r
    case software.amazon.awssdk.services.wafv2.model.ResourceType.COGNITO_USER_POOL =>
      val r = COGNITO_USER_POOL
      r
    case software.amazon.awssdk.services.wafv2.model.ResourceType.APP_RUNNER_SERVICE =>
      val r = APP_RUNNER_SERVICE
      r
    case software.amazon.awssdk.services.wafv2.model.ResourceType.VERIFIED_ACCESS_INSTANCE =>
      val r = VERIFIED_ACCESS_INSTANCE
      r
  }
  case object unknownToSdkVersion extends zio.aws.wafv2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResourceType =
      software.amazon.awssdk.services.wafv2.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object APPLICATION_LOAD_BALANCER
      extends zio.aws.wafv2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResourceType =
      software.amazon.awssdk.services.wafv2.model.ResourceType.APPLICATION_LOAD_BALANCER
  }
  case object API_GATEWAY extends zio.aws.wafv2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResourceType =
      software.amazon.awssdk.services.wafv2.model.ResourceType.API_GATEWAY
  }
  case object APPSYNC extends zio.aws.wafv2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResourceType =
      software.amazon.awssdk.services.wafv2.model.ResourceType.APPSYNC
  }
  case object COGNITO_USER_POOL extends zio.aws.wafv2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResourceType =
      software.amazon.awssdk.services.wafv2.model.ResourceType.COGNITO_USER_POOL
  }
  case object APP_RUNNER_SERVICE extends zio.aws.wafv2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResourceType =
      software.amazon.awssdk.services.wafv2.model.ResourceType.APP_RUNNER_SERVICE
  }
  case object VERIFIED_ACCESS_INSTANCE
      extends zio.aws.wafv2.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResourceType =
      software.amazon.awssdk.services.wafv2.model.ResourceType.VERIFIED_ACCESS_INSTANCE
  }
}
