package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait ResponseContentType {
  def unwrap: software.amazon.awssdk.services.wafv2.model.ResponseContentType
}
object ResponseContentType {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.ResponseContentType
  ): zio.aws.wafv2.model.ResponseContentType = value match {
    case software.amazon.awssdk.services.wafv2.model.ResponseContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.ResponseContentType.TEXT_PLAIN =>
      val r = TEXT_PLAIN
      r
    case software.amazon.awssdk.services.wafv2.model.ResponseContentType.TEXT_HTML =>
      val r = TEXT_HTML
      r
    case software.amazon.awssdk.services.wafv2.model.ResponseContentType.APPLICATION_JSON =>
      val r = APPLICATION_JSON
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafv2.model.ResponseContentType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResponseContentType =
      software.amazon.awssdk.services.wafv2.model.ResponseContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object TEXT_PLAIN extends zio.aws.wafv2.model.ResponseContentType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResponseContentType =
      software.amazon.awssdk.services.wafv2.model.ResponseContentType.TEXT_PLAIN
  }
  case object TEXT_HTML extends zio.aws.wafv2.model.ResponseContentType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResponseContentType =
      software.amazon.awssdk.services.wafv2.model.ResponseContentType.TEXT_HTML
  }
  case object APPLICATION_JSON extends zio.aws.wafv2.model.ResponseContentType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ResponseContentType =
      software.amazon.awssdk.services.wafv2.model.ResponseContentType.APPLICATION_JSON
  }
}
