package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResponseInspection(
    statusCode: Optional[zio.aws.wafv2.model.ResponseInspectionStatusCode] =
      Optional.Absent,
    header: Optional[zio.aws.wafv2.model.ResponseInspectionHeader] =
      Optional.Absent,
    bodyContains: Optional[zio.aws.wafv2.model.ResponseInspectionBodyContains] =
      Optional.Absent,
    json: Optional[zio.aws.wafv2.model.ResponseInspectionJson] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ResponseInspection = {
    import ResponseInspection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ResponseInspection
      .builder()
      .optionallyWith(statusCode.map(value => value.buildAwsValue()))(
        _.statusCode
      )
      .optionallyWith(header.map(value => value.buildAwsValue()))(_.header)
      .optionallyWith(bodyContains.map(value => value.buildAwsValue()))(
        _.bodyContains
      )
      .optionallyWith(json.map(value => value.buildAwsValue()))(_.json)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ResponseInspection.ReadOnly =
    zio.aws.wafv2.model.ResponseInspection.wrap(buildAwsValue())
}
object ResponseInspection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ResponseInspection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ResponseInspection =
      zio.aws.wafv2.model.ResponseInspection(
        statusCode.map(value => value.asEditable),
        header.map(value => value.asEditable),
        bodyContains.map(value => value.asEditable),
        json.map(value => value.asEditable)
      )
    def statusCode
        : Optional[zio.aws.wafv2.model.ResponseInspectionStatusCode.ReadOnly]
    def header: Optional[zio.aws.wafv2.model.ResponseInspectionHeader.ReadOnly]
    def bodyContains
        : Optional[zio.aws.wafv2.model.ResponseInspectionBodyContains.ReadOnly]
    def json: Optional[zio.aws.wafv2.model.ResponseInspectionJson.ReadOnly]
    def getStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.ResponseInspectionStatusCode.ReadOnly
    ] = AwsError.unwrapOptionField("statusCode", statusCode)
    def getHeader: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.ResponseInspectionHeader.ReadOnly
    ] = AwsError.unwrapOptionField("header", header)
    def getBodyContains: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.ResponseInspectionBodyContains.ReadOnly
    ] = AwsError.unwrapOptionField("bodyContains", bodyContains)
    def getJson: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.ResponseInspectionJson.ReadOnly
    ] = AwsError.unwrapOptionField("json", json)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ResponseInspection
  ) extends zio.aws.wafv2.model.ResponseInspection.ReadOnly {
    override val statusCode
        : Optional[zio.aws.wafv2.model.ResponseInspectionStatusCode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value =>
          zio.aws.wafv2.model.ResponseInspectionStatusCode.wrap(value)
        )
    override val header
        : Optional[zio.aws.wafv2.model.ResponseInspectionHeader.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.header())
        .map(value => zio.aws.wafv2.model.ResponseInspectionHeader.wrap(value))
    override val bodyContains: Optional[
      zio.aws.wafv2.model.ResponseInspectionBodyContains.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bodyContains())
      .map(value =>
        zio.aws.wafv2.model.ResponseInspectionBodyContains.wrap(value)
      )
    override val json
        : Optional[zio.aws.wafv2.model.ResponseInspectionJson.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.json())
        .map(value => zio.aws.wafv2.model.ResponseInspectionJson.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ResponseInspection
  ): zio.aws.wafv2.model.ResponseInspection.ReadOnly = new Wrapper(impl)
}
