package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.{
  FailureValue,
  SuccessValue,
  FieldIdentifier
}
import scala.jdk.CollectionConverters.*
final case class ResponseInspectionJson(
    identifier: FieldIdentifier,
    successValues: Iterable[SuccessValue],
    failureValues: Iterable[FailureValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ResponseInspectionJson = {
    import ResponseInspectionJson.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ResponseInspectionJson
      .builder()
      .identifier(FieldIdentifier.unwrap(identifier): java.lang.String)
      .successValues(successValues.map { item =>
        SuccessValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .failureValues(failureValues.map { item =>
        FailureValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ResponseInspectionJson.ReadOnly =
    zio.aws.wafv2.model.ResponseInspectionJson.wrap(buildAwsValue())
}
object ResponseInspectionJson {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ResponseInspectionJson
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ResponseInspectionJson =
      zio.aws.wafv2.model
        .ResponseInspectionJson(identifier, successValues, failureValues)
    def identifier: FieldIdentifier
    def successValues: List[SuccessValue]
    def failureValues: List[FailureValue]
    def getIdentifier: ZIO[Any, Nothing, FieldIdentifier] =
      ZIO.succeed(identifier)
    def getSuccessValues: ZIO[Any, Nothing, List[SuccessValue]] =
      ZIO.succeed(successValues)
    def getFailureValues: ZIO[Any, Nothing, List[FailureValue]] =
      ZIO.succeed(failureValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ResponseInspectionJson
  ) extends zio.aws.wafv2.model.ResponseInspectionJson.ReadOnly {
    override val identifier: FieldIdentifier =
      zio.aws.wafv2.model.primitives.FieldIdentifier(impl.identifier())
    override val successValues: List[SuccessValue] = impl
      .successValues()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.SuccessValue(item)
      }
      .toList
    override val failureValues: List[FailureValue] = impl
      .failureValues()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.FailureValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ResponseInspectionJson
  ): zio.aws.wafv2.model.ResponseInspectionJson.ReadOnly = new Wrapper(impl)
}
