package zio.aws.wafv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.{FailureCode, SuccessCode}
import scala.jdk.CollectionConverters.*
final case class ResponseInspectionStatusCode(
    successCodes: Iterable[SuccessCode],
    failureCodes: Iterable[FailureCode]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ResponseInspectionStatusCode = {
    import ResponseInspectionStatusCode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ResponseInspectionStatusCode
      .builder()
      .successCodes(successCodes.map { item =>
        SuccessCode.unwrap(item): Integer
      }.asJavaCollection)
      .failureCodes(failureCodes.map { item =>
        FailureCode.unwrap(item): Integer
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ResponseInspectionStatusCode.ReadOnly =
    zio.aws.wafv2.model.ResponseInspectionStatusCode.wrap(buildAwsValue())
}
object ResponseInspectionStatusCode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ResponseInspectionStatusCode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ResponseInspectionStatusCode =
      zio.aws.wafv2.model
        .ResponseInspectionStatusCode(successCodes, failureCodes)
    def successCodes: List[SuccessCode]
    def failureCodes: List[FailureCode]
    def getSuccessCodes: ZIO[Any, Nothing, List[SuccessCode]] =
      ZIO.succeed(successCodes)
    def getFailureCodes: ZIO[Any, Nothing, List[FailureCode]] =
      ZIO.succeed(failureCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ResponseInspectionStatusCode
  ) extends zio.aws.wafv2.model.ResponseInspectionStatusCode.ReadOnly {
    override val successCodes: List[SuccessCode] = impl
      .successCodes()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.SuccessCode(item)
      }
      .toList
    override val failureCodes: List[FailureCode] = impl
      .failureCodes()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.FailureCode(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ResponseInspectionStatusCode
  ): zio.aws.wafv2.model.ResponseInspectionStatusCode.ReadOnly = new Wrapper(
    impl
  )
}
