package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class RuleSummary(
    name: Optional[EntityName] = Optional.Absent,
    action: Optional[zio.aws.wafv2.model.RuleAction] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.RuleSummary = {
    import RuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.RuleSummary
      .builder()
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.RuleSummary.ReadOnly =
    zio.aws.wafv2.model.RuleSummary.wrap(buildAwsValue())
}
object RuleSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.RuleSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.RuleSummary =
      zio.aws.wafv2.model.RuleSummary(
        name.map(value => value),
        action.map(value => value.asEditable)
      )
    def name: Optional[EntityName]
    def action: Optional[zio.aws.wafv2.model.RuleAction.ReadOnly]
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getAction: ZIO[Any, AwsError, zio.aws.wafv2.model.RuleAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.RuleSummary
  ) extends zio.aws.wafv2.model.RuleSummary.ReadOnly {
    override val name: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafv2.model.primitives.EntityName(value))
    override val action: Optional[zio.aws.wafv2.model.RuleAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.wafv2.model.RuleAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.RuleSummary
  ): zio.aws.wafv2.model.RuleSummary.ReadOnly = new Wrapper(impl)
}
